<?
#error_log('########################################             ' . $_SERVER['QUERY_STRING'] . "              ######################## ");
/* {{{ Setup */
include('functions.php');
include('pclzip.lib.php');
define('DOWNLOAD_RANGE_SIZE', 250000);
define('UNZIP_RANGE_SIZE', 15);

session_start();
if (empty($_SESSION['user_id'])) {
    $rootdir = dirname(dirname($_SERVER['SCRIPT_NAME']));
    header('Location: '.$rootdir);
}
$version= PPVDEMON_VERSION;
dbconnect();

if (!empty($_GET['r'])) {
    $redirect = $_GET['r'];
} else {
    $redirect = $base_url . 'index.php/ppv_accounts';
}

$user_id = $_SESSION['user_id'];
$result = mysql_query('SELECT license_key, user_pass FROM pd_users WHERE user_id = '.$user_id);
$row = mysql_fetch_assoc($result);
mysql_free_result($result);
$params = array(
    'auth1' => sha1($row['license_key'] . AUTH1_SALT),
    'auth2' => sha1($row['user_pass'] . AUTH2_SALT),
    'domain' => $base_url,
    'currentversion' => $version,
);
$updateurl = UPDATES_URL . '?' . http_build_query($params);

function meta_redirect($url, $message) {
    print "<html>
        <head>
        <title>$message</title>
        <meta http-equiv='refresh' content='0; url=$url'>
        </head>

        <body>

            <h3>$message</h3>

        </body>
        </html>";
    die();
}

function framebuster_redirect($url, $message) {
    print "<html>
        <head>
        <title>$message</title>
        <script language='javascript'>
            top.location='$url';
        </script>
        </head>
        
        <body>

            <h3>$message</h3>

        </body>
        </html>";
    die();
}

function get_upgrade_info() {
    global $updateurl;
    $info = array();
    #error_log('fetching info . . .');

    $res = simplexml_load_url_curl($updateurl);
    if (count($res->updates)) {
        $info['needs_upgrade'] = true;
        $info['nextversion'] = $res->updates->update[0];
        if (count($res->updates->update) > 1) {
            $info['nextnextversion'] = $res->updates->update[1];
        } else {
            $info['nextnextversion'] = false;
        }
        $info['latestversion'] = $res->updates->update[count($res->updates->update)-1];

        $info['runningtotalsize']= 0;
        foreach ($res->updates->update as $version) {
            $info['runningtotalsize'] += $version['size'];
        }
    } else {
        $info['needs_upgrade'] = false;
    }

    return $info;
}

if (!isset($_GET['upgradenext'])) {
    $info = get_upgrade_info();
    extract($info);
} else {
    $currentversion = PPVDEMON_VERSION;

    if (!isset($_GET['stage'])) {
        $stage = 'prepare';
    } else {
        $stage = $_GET['stage'];
    }

    $thisdir = dirname($_SERVER['SCRIPT_FILENAME']) . '/';
    $rootdir = dirname($thisdir) . '/';

    if ($stage == 'prepare') {

        $info = get_upgrade_info();

        $v = (string)$info['nextversion']['version'];
        if ($_GET['upgradenext'] != $v) {
            header('Location: ?');
        }

        $dir = $thisdir . 'files/'.$v . '/';
        $olddir = $thisdir . 'files/' . $currentversion . '/rollback/';
        $realdir = $rootdir;

        if (!file_exists($dir)) {
            mkdir($dir, 0777, true);
        }
        if (!file_exists($olddir)) {
            mkdir($olddir, 0777, true);
        }


        $get = $_GET;
        $get['stage'] = 'download';
        $get['size'] = (string)$info['nextversion']['size'];
        $url = '?' . http_build_query($get);
        meta_redirect($url, 'Downloading . . .');

    } elseif ($stage == 'download') {
        $nextversion = $_GET['upgradenext'];
        $size = $_GET['size'];
        $dir = $thisdir . 'files/'.$nextversion . '/';

        if (!isset($_GET['step'])) {
            $step = 0;
        } else {
            $step = $_GET['step'];
        }

        $range1 = $step * DOWNLOAD_RANGE_SIZE;
        $range2 = (($step+1) * DOWNLOAD_RANGE_SIZE);
        if ($range1 > $size) {
            $get = $_GET;
            $get['step'] = '';
            $get['stage'] = 'unzip';
            meta_redirect('?' . http_build_query($get), 'Checking permissions . . .');
        }

        $nextversion_url = $updateurl . "&" . http_build_query(
            array('getversion'=>$nextversion,
                  'range1' => $range1,
                  'range2' => $range2)
        );

        if ($step == 0 && file_exists($dir . 'upgrade.zip')) {
            unlink($dir . 'upgrade.zip');
        }

        $fh = fopen($dir . 'upgrade.zip', 'a');

        $c = curl_init($nextversion_url);
        curl_setopt($c, CURLOPT_FILE, $fh);
        curl_exec($c);
        fclose($fh);

        $get = $_GET;
        $get['step'] = $step + 1;
        meta_redirect('?' . http_build_query($get), "Downloading version $nextversion archive chunk # ".($step+1)." / ".ceil($size/DOWNLOAD_RANGE_SIZE)." . . .");

    } elseif ($stage == 'unzip') {
        $nextversion = $_GET['upgradenext'];
        $dir = $thisdir . 'files/'.$nextversion . '/';
        $olddir = $thisdir . 'files/' . $currentversion . '/rollback/';
        $realdir = $rootdir;

        if (!isset($_GET['step']) || $_GET['step'] == '') {
            $step = '';
        } else {
            $step = $_GET['step'];
        }


        $zip = new PclZip($dir . 'upgrade.zip');
        if ($zip) {
            $zipfiles = $zip->listContent();

            $permission_problems = false;
            if ($step == '') { 
                for ($i = 0; $i < sizeof($zipfiles); $i++) {
                    $fname = $zipfiles[$i]['filename'];
                    if (file_exists($realdir . $fname) && !is_writeable($realdir . $fname)) {
                        if (!$permission_problems) {
                            echo('<h3>Fix these permissions problems and <a href="?'.http_build_query($_GET).'">click here</a> to try again.</h3>');
                        }
                        $permission_problems = true;
                        ?><i><?=$realdir . $fname?> is not writeable. <br /><b>chmod 777 <?=$realdir . $fname?></b> to fix this problem.</i><br /><?
                    } elseif (!file_exists($realdir . $fname) && !is_writeable($realdir . dirname($fname))) {
                        if (file_exists(dirname($realdir . $fname))) {
                            $permission_problems = true;
                            ?><i><?=$realdir . $fname?> can not be created. <br /><b>chmod 777 <?=$realdir . dirname($fname)?></b> to fix this problem.</i><br /><?
                        }
                    }
                }
                if ($permission_problems) {
                    die('<h3>Fix these permissions problems and <a href="?'.http_build_query($_GET).'">click here</a> to try again.</h3>');
                } else {
                    $get = $_GET;
                    $get['step'] = 0;
                    meta_redirect('?' . http_build_query($get), "Unzipping . . .");
                }
            } else {

                $range1 = $step * UNZIP_RANGE_SIZE;
                $range2 = (($step+1) * UNZIP_RANGE_SIZE);
                if ($range2 > sizeof($zipfiles)) {
                    $range2 = sizeof($zipfiles);
                }
                if ($range1 > sizeof($zipfiles)) {
                    $get = $_GET;
                    $get['stage'] = 'upgradesql';
                    meta_redirect('?' . http_build_query($get), "Executing Database Upgrade . . .");
                }
                for ($i = $range1; $i < $range2; $i++) {
                    $fname = $zipfiles[$i]['filename'];
                    if (substr($fname, -1) != '/') { # it's a file
                        if (file_exists($realdir . $fname)) { # the file exists in the installation
                            error_log("Replacing $fname");
                            if (!file_exists($olddir.dirname($fname))) { # the directory doesn't exist in our rollback dir
                                mkdir($olddir . dirname($fname), 0777, true);
                            }
                            copy($realdir . $fname, $olddir . $fname);
                        } else {
                            error_log("Creating $fname");
                        }
                    }
                    $zip->extract(PCLZIP_OPT_PATH, $realdir, PCLZIP_OPT_BY_INDEX, $i, PCLZIP_OPT_REPLACE_NEWER);
                }
                $get = $_GET;
                $get['step'] = $step + 1;
                meta_redirect('?' . http_build_query($get), "Unzipping chunk # ".($step+1)." / ".ceil(sizeof($zipfiles) / UNZIP_RANGE_SIZE).". . .");
            }
        }

    } elseif ($stage == 'upgradesql') {
        $nextversion = $_GET['upgradenext'];
        $dir = $thisdir . 'files/'.$nextversion . '/';
        $realdir = $rootdir;
        if (file_exists($realdir . 'upgrade.sql')) {
            error_log("Executing Database Upgrade . . .");
            mysql_import_file($realdir . 'upgrade.sql', $message);
            if ($message) {
                die($message);
            }
            unlink($realdir . 'upgrade.sql');
        }
        framebuster_redirect('?upgradecomplete', 'Upgrade Complete.');
    }

}
/* }}} */

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US" xml:lang="en-US">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>PPV Demon</title>
        <link href="style.css" rel="stylesheet" type="text/css" />
</head>

<body>
<div class="wrap_install">
<h1 id="logo"><img alt="PPVDemon" src="logo.png" /></h1>

<?php

if (isset($_GET['upgradecomplete'])) {
    print "<h2>Upgrade is complete.</h2>";
}

if ($needs_upgrade) {

    if (!isset($_GET['doupgrade'])) {
?>
<br />The latest version of PPV Demon is <b><?=$latestversion['version']?></b>. You are running version <b><?=PPVDEMON_VERSION?></b>.

<br />

<br />

<a href="?doupgrade">Click here</a> to upgrade to the next version <b><?=$nextversion['version']?></b> (<?=$nextversion['size']?> bytes).

<br />or <a href="<?=$redirect?>">Click here to continue without upgrading</a>
    <?}else{?>

    <h3>Upgrade to <?=$nextversion['version']?> in progress. . . </h3>

<br /><br />
<iframe style="border:0;" src="?upgradenext=<?=$nextversion['version']?>" id="progress" name="progress" height="600" width="100%"></iframe>

<?
    }
} else {?>

<h1>No New Updates available </h1>

Your PPVDemon version <?=PPVDEMON_VERSION?> is up to date.
<br /><a href="<?=$redirect?>">Click here to continue</a>

<?}?>

</body>
</html>
