<?php

/**
 * 
 * This class is for prefered host installs.
 * @author mcraig
 *
 */

class prefered_host_model extends Model {
	
	/**
	 * debug
	 * a boolean var used for debugging only TRUE = DEBUG ON; FALSE = DEBUG OFF
	 * @var Boolean
	 */
	var $debug;	

	/**
	 * prefered_host_model()
	 * init method
	 */
	function prefered_host_model() {
		parent::Model();
		
		// Debug options
		$this->debug = FALSE;
		$this->output->enable_profiler(FALSE);
		
		// Call the db handler just incase it isn't any place else.
		$this->load->database();
		$this->load->helper(array('simplexml_load_url_curl'));
		
		log_message('debug', 'Prefered Host model loaded.');
	}
	
	/**
	 * This function is used for DEBUG ONLY
	 * 
	 * @param mixed $var
	 * @param string $msg
	 */
	function _dump($var = null, $msg = '') {
		if ($this->debug) {
			echo "<h1>$msg</h1><pre>";
			var_dump($var);
			echo "</pre>";
		}
	}

	/**
	 * check_for_user()
	 * Check to see if there is a user..
	 * @return 	Boolean  TRUE if there is a user/ FALSE if no user.
	 */
	function check_user() {
		// Get the user list
		$query = $this->db->get('pd_users');
		
		if($query->num_rows() > 0) {
			$user = $query->row();
			if (empty($user->user_name)) {
				// THE FIRST User is empty...
				return FALSE;			
			}
			if (empty($user->user_email)) {
				// Empty email				
				return FALSE;
			}
			if (empty($user->user_pass)) {
				// Empty pass...?
				return FALSE;
			}
		} else {
			// THERE ARE NO USERS!!!!
			return FALSE;
		}
		return TRUE;
	}
	
	/**
	 * check_licence()
	 * This ensures there is a recept in the db.
	 * @return 	boolean  	TRUE if all is well/ FALSE if bad...
	 */
	function check_for_licence() {
		
		// Get the user list
		$query = $this->db->get('pd_users');
		
		if($query->num_rows() > 0) {

			$user = $query->row();
			
			// If there is a licence 
			if(!empty($user->license_key)) {
				return TRUE;
			} else {
				return FALSE;
			}

		} else {
			// THRE ARE NO USERS!!!
			return FALSE;
		}
	}
	

	/**
	 * register($licence_key)
	 * This function registers a Prefered host license key
	 * @param 	string 	$licence_key	The key to be registered.
	 * @return 	Boolen	Returns TRUE if it was able to update / FALSE if there was an error of any kind.
	 */
	function register ($licence_key = null) {
		
		// Get the user list
		$query = $this->db->get('pd_users');
		
		// Make sure we have enough data to continue....
		if($query->num_rows() > 0) {
			$user = $query->row();
			if (empty($user->user_name)) {
				// THE FIRST User is empty...
				return FALSE;			
			}
			if (empty($user->user_email)) {
				// Empty email				
				return FALSE;
			}
			if (empty($user->user_pass)) {
				// Empty pass...?
				return FALSE;
			}
		} else {
			return FALSE;
		}
		
		 // query to see if their licence is valid...
		 $apiURI= LIC_API_URL."?operation=db_query".
            "&licence_key=".$licence_key;

			$this->_dump($apiURI, 'Licence Check');
			
		 	$xml_update = simplexml_load_url_curl($apiURI);
			
            $this->_dump($xml_update, 'Licence Check - Results');

            // If there are no results... stop the licence is invalid.
            if (count($xml_update->entries->entry) == 0) {
            	$this->_dump(null, 'No Entries Found');
            	log_message('debug', 'There was no matching licence found.');
            	return FALSE; 
            } 
                        
			// Check to see if they have already registered...
			// This prevents someone using someone else's key.
			$xml_domain = trim((string) $xml_update->entries->entry[0]->domain);

			if ($xml_domain != 'null' ) {
				$this->_dump($xml_domain, 'Domain is full already.');
				log_message('error', 'If this case happens they have no licence key, but the key they gave is taken on the licence server.');
				return FALSE;
			}
			
			// If licence keys match...
			$xml_licence = trim((string) $xml_update->entries->entry[0]->licence_key);
			
			// a quick sanity check to make sure the license key matches...
			if ($xml_licence == $licence_key) {
				
				$this->_dump($xml_licence, 'Keys Matched.');
					
				// Build the API query
				$apiURI_update= LIC_API_URL."?operation=insert_db".
		            "&licence_key=".$licence_key.
		            "&domain=".base_url().
		            "&username=".$user->user_name.
		            "&eMail=".$user->user_email.
		            "&password=".$user->user_pass.
		            "&security_question_1=".
		            "&security_question_2=".
		            "&answer_1=".
		            "&answer_2=".
		            "&status=1".
		            "&security=0";
				
				$this->_dump($apiURI_update, 'Update DB URI');
				
	            $xml_update = simplexml_load_url_curl($apiURI_update);
	           	
				$this->_dump($xml_update, 'Update DB XML Results');
	            
				$xml_status = (integer) trim($xml_update->success[0]);
				
				// IF the status was returned as 1
	            if($xml_status == 1) {
	            	$this->_dump($xml_status, 'Everything Worked and We are updated');
	            	$data = array('license_key' => $licence_key);
					$this->db->where('user_id', $user->user_id);
					$this->db->update('pd_users', $data);
	            	return TRUE;
	            } else {
	            	$this->_dump($xml_status, 'There was a final problem...');
	            	return FALSE;
	            }
	            
	        } else {
	        	$this->_dump($xml_licence, 'Keys did NOT Match.');
	        	return FALSE;
	        }
			
	}
	
}

/* End of file prefered_host_model.php */
/* Location: ./system/application/models/prefered_host_model.php */
