<?php 

require_once(FCPATH . 'updates/pclzip.lib.php');

class plugins_ctrl extends Controller 
{
		function plugins_ctrl()
		{
		parent::Controller();
		$this->load->model('user_model','',TRUE);
		$this->load->helper(array('text','form','date','url','session','common','error','admin','db'));
		$this->load->library(array('user_entry','validation','form_validation','session'));
                $this->MAX_FILE_SIZE = 10000000;
                $this->upload_path = FCPATH . 'plugin_uploads/';
                $this->installed_path = FCPATH . 'plugin_uploads/installed/';
                $this->upload_path_name = '/plugin_uploads/';
		}
		function index()
		{
                    $top_error = '';
                    $msg = '';
                    if (!is_writeable($this->upload_path)) {
                        $top_error = 'Plugin Upload Directory is not writeable. <i>chmod 777 '.$this->upload_path.'</i> and try again.';
                    } elseif (!is_writeable($this->installed_path)) {
                        $top_error = 'Plugin Upload Directory is not writeable. <i>chmod 777 '.$this->installed_path.'</i> and try again.';
                    } else {
                        if (isset($_POST['upload'])) {
                            $f = $_FILES['plugin_file'];
                            if (in_array($f['type'], array('application/zip', 'application/download', 'application/x-zip', 'application/x-zip-compressed', 'application/x-compress', 'application/x-compressed', 'application/octet-stream', 'multipart/x-zip')) && $f['size'] <= $this->MAX_FILE_SIZE) {
                                if (move_uploaded_file($f['tmp_name'], $this->upload_path . $f['name'])) {
                                    $msg = 'Successfully uploaded <b>' . $f['name'] . '</b>.';
                                } else {
                                    $msg = 'Error uploading file.';
                                }
                            } else {
                                if ($f['error'] == UPLOAD_ERR_INI_SIZE) {
                                    $msg = 'The <i>upload_max_filesize</i> setting in your php.ini is set to <i>'.ini_get('upload_max_filesize').'</i>. Increase it to upload this file, or upload it yourself into ' . $this->upload_path_name . ' via FTP.' ;
                                } else {
                                    $msg = 'Invalid file or file size.';
                                }
                            }
                        } elseif (isset($_GET['action'])) {
                            $action = $_GET['action'];
                            if ($action == 'install') {
                                $f = $this->upload_path . $this->_sanitize($_GET['file']);
                            } elseif ($action == 'reinstall') {
                                $f = $this->installed_path . $this->_sanitize($_GET['file']);
                            }
                            if (!empty($f) && file_exists($f)) {
                                $msg = $this->_install($f);
                            } else {
                                redirect('plugins_ctrl');
                            }
                        }
                    }
                    $this->load->view('plugins', array(
                        'upload_path_name'=>$this->upload_path_name, 
                        'top_error'=>$top_error,
                        'msg'=>$msg,
                        'plugins'=>$this->_list_plugins(),
                    ));
		}

                function _sanitize($filename) {
                    return preg_replace('/[\/\\\\]/', '', $filename);

                }

                function _install($file) {
                    if (!file_exists($file)) {
                        return basename($file) . " doesn't exist.";
                    }

                    $zip = new PclZip($file);
                    if ($zip) {
                        $zipfiles = $zip->listContent();
                        $permission_problems = false;
                        for ($i = 0; $i < sizeof($zipfiles); $i++) {
                            $fname = $zipfiles[$i]['filename'];
                            $fullpath = FCPATH . $fname;
                            if (file_exists($fullpath) && !is_writeable($fullpath)) {
                                if (!$permission_problems) {
                                    $msg='<h3>Fix these permissions problems and <a href="?'.http_build_query($_GET).'">click here</a> to try again.</h3>';
                                }
                                $permission_problems = true;
                                $msg .= "<i>$fullpath is not writeable. <br /><b>chmod 777 $fullpath</b> to fix this problem.</i><br />";
                            } elseif (!file_exists($fullpath) && !is_writeable(dirname($fullpath))) {
                                if (!$permission_problems) {
                                    $msg='<h3>Fix these permissions problems and <a href="?'.http_build_query($_GET).'">click here</a> to try again.</h3>';
                                }
                                $permission_problems = true;
                                $msg .= "<i>".dirname($fullpath)." is not writeable. <br /><b>chmod 777 ".dirname($fullpath)."</b> to fix this problem.</i><br />";
                            }
                        }
                        if ($permission_problems) {
                            return $msg;
                        } else {
                            for ($i = 0; $i < sizeof($zipfiles); $i++) {
                                $zip->extract(PCLZIP_OPT_PATH, FCPATH, PCLZIP_OPT_BY_INDEX, $i, PCLZIP_OPT_REPLACE_NEWER);
                            }
                            if ($file != $this->installed_path . basename($file)) {
                                rename($file, $this->installed_path . basename($file));
                            }
                        }

                    }

                    return "Installed!";
                }

                function _list_plugins() {
                    $files = glob($this->upload_path . '*.zip');
                    $installed_files = glob($this->installed_path . '*.zip');
                    $plugins = array();
                    foreach ($files as $file) {
                        $plugins[]=array(
                            'file_name' => basename($file),
                            'nice_name' => ucwords(str_replace('_', ' ', basename($file, '.zip'))),
                            'installed' => 0
                        );
                    }
                    foreach ($installed_files as $file) {
                        $plugins[]=array(
                            'file_name' => basename($file),
                            'nice_name' => ucwords(str_replace('_', ' ', basename($file, '.zip'))),
                            'installed' => 1
                        );
                    }
                    return $plugins;
                }
}
?>
